# Casio dictionary NAND Update Image builder - nand_build.py
#
# This software is provided ‘as-is’, without any express or implied
# warranty. In no event will the authors be held liable for any damages
# arising from the use of this software.
# 
# Permission is granted to anyone to use this software for any purpose,
# including commercial applications, and to alter it and redistribute it
# freely, subject to the following restrictions:
# 
# 1. The origin of this software must not be misrepresented; you must not
# claim that you wrote the original software. If you use this software
# in a product, an acknowledgment in the product documentation would be
# appreciated but is not required.
# 
# 2. Altered source versions must be plainly marked as such, and must not be
# misrepresented as being the original software.
# 
# 3. This notice may not be removed or altered from any source
# distribution.


import sys
import opts
from layoutparser import LayoutParser
from nand import NandGenerator

parser = opts.OptionParser(usage="usage: %prog [options] path/to/files filename")
parser.add_option('-l', '--layout', dest="layout", action='store', help='sets the NAND layout to use', required=1, type="choice", choices=LayoutParser.get_layouts())
parser.add_option('-m', '--model', dest="model", action='store', help='sets the dictionary model to use', required=1)
parser.add_option('-e', '--ext-model', dest="ext_model", action='store', help='sets the dictionary extended model to use', default="\xff" * 8)
parser.add_option('-v', '--version', dest="version", action='store', help='sets the data version', default=0x100, type=int)
parser.add_option('-t', '--timestamp', dest="timestamp", action='store', help='sets the timestamp to use (e.g. "2010/05/20 10:10:30")')

(options, args) = parser.parse_args()
if len(args) != 2:
  parser.print_help()
  sys.exit(1)

layout = LayoutParser(options.layout)
layout.set("version", str(options.version))
layout.set("model", options.model)
layout.set("ext_model", options.ext_model)

nand = NandGenerator(args[0], layout, options.timestamp)
nand.write_nand(args[1])

