# Casio dictionary NAND Update Image builder - layoutparser.py
#
# This software is provided ‘as-is’, without any express or implied
# warranty. In no event will the authors be held liable for any damages
# arising from the use of this software.
# 
# Permission is granted to anyone to use this software for any purpose,
# including commercial applications, and to alter it and redistribute it
# freely, subject to the following restrictions:
# 
# 1. The origin of this software must not be misrepresented; you must not
# claim that you wrote the original software. If you use this software
# in a product, an acknowledgment in the product documentation would be
# appreciated but is not required.
# 
# 2. Altered source versions must be plainly marked as such, and must not be
# misrepresented as being the original software.
# 
# 3. This notice may not be removed or altered from any source
# distribution.


import configparser
from glob import glob
from os.path import basename
from os.path import dirname
from os.path import splitext
from os.path import realpath

class RawConfigParser (configparser.RawConfigParser):
    def optionxform(self, option):
        return option

    def merge_sections(self, section1, section2):
        if not self.has_section(section1):
            self.add_section(section1)
        if self.has_section(section2):
            for (name, value) in self.items(section2):
                self.set(section1, name, value)
            self.remove_section(section2)


class LayoutParser:
    PATH = "%s/_layouts/" % dirname(realpath(__file__))
    def __init__(self, layout):
        self.config = RawConfigParser()
        self.config.read(["%scommon.ini" % self.PATH, "%s%s.ini" % (self.PATH, layout)])
        if not self.config.has_section(layout):
            raise configparser.NoSectionError("Layout '%s' not found" % layout)
        self.config.merge_sections(layout, "common")
        self.layout = layout

    def items(self):
        return self.config.items(self.layout)

    def options(self):
        return self.config.options(self.layout)

    def has_option(self, option):
        return self.config.has_option(self.layout, option)

    def get(self, option):
        return self.config.get(self.layout, option)

    def getint(self, option):
        return int(self.config.get(self.layout, option), 0)

    def set(self, option, value):
        return self.config.set(self.layout, option, value)

    @staticmethod
    def get_layouts():
        return [splitext(basename(i))[0] for i in sorted(glob("%s*.ini" % LayoutParser.PATH)) if basename(i) != "common.ini"]
        
