# Casio DP5 NOR image decryptor (python2)
#
# This software is provided ‘as-is’, without any express or implied
# warranty. In no event will the authors be held liable for any damages
# arising from the use of this software.
# 
# Permission is granted to anyone to use this software for any purpose,
# including commercial applications, and to alter it and redistribute it
# freely, subject to the following restrictions:
# 
# 1. The origin of this software must not be misrepresented; you must not
# claim that you wrote the original software. If you use this software
# in a product, an acknowledgment in the product documentation would be
# appreciated but is not required.
# 
# 2. Altered source versions must be plainly marked as such, and must not be
# misrepresented as being the original software.
# 
# 3. This notice may not be removed or altered from any source
# distribution.


import struct, ctypes, sys, os, os.path, array

class EncWrapper:
  def __init__(self, f):
    keyfname = os.path.join(os.path.dirname(os.path.abspath(__file__)), "enckey.bin")
    self.keydata = array.array('B', open(keyfname, "rb").read())
    self.file = f
  def seek(self, off, whence = 0):
    return self.file.seek(off, whence)
  def tell(self):
    return self.file.tell()
  def size(self):
    self.file.seek(0, 2)
    sz = self.file.tell()
    self.file.seek(0,0)
    return sz;
  def read(self, size):
    curoff = self.file.tell()
    arrdata = array.array('B', self.file.read(size))
    for i in range(size):
      arrdata[i] ^= self.keydata[curoff&0x3FF]
      curoff += 1
    return arrdata.tostring()


if len(sys.argv) != 3:
  print "usage: decrypt.py <enc filename> <dec filename>"
  sys.exit(1)

f = open(sys.argv[1], "rb")
encw = EncWrapper(f)
print "Decrypting file %s" % sys.argv[1]
sz = encw.size()
open(sys.argv[2], "wb").write(encw.read(sz))
