#include "crc32.h"

static uint32_t crc32_table[256];


static uint32_t crc32_reflect(uint32_t reflect, const char c)
{
	int i;
	uint32_t val = 0;

	for(i = 1; i < (c + 1); ++i) {
		if(reflect & 1) {
			val |= (1 << (c - i));
		}
		reflect >>= 1;
	}
	return val;
}

void crc32_init(void)
{
	int i, j;
	//0x04C11DB7 is the official polynomial used by PKZip, WinZip and Ethernet.
	uint32_t poly = 0x04C11DB7;

	memset(crc32_table, 0, sizeof(crc32_table));

	for(i = 0; i <= 0xFF; ++i) {
		crc32_table[i] = crc32_reflect(i, 8) << 24;

		for(j = 0; j < 8; ++j) {
			crc32_table[i] = (crc32_table[i] << 1)
				^ ((crc32_table[i] & (1 << 31)) ? poly : 0);
		}

		crc32_table[i] = crc32_reflect(crc32_table[i], 32);
	}
}


void crc32_partial(uint32_t *crc, const unsigned char *s, size_t len)
{
	while(len--) {
		*crc = (*crc >> 8) ^ crc32_table[(*crc & 0xFF) ^ *s++];
	}
}

void crc32_full(const unsigned char *s, size_t len, uint32_t *crc)
{
	*crc = 0xffffffff;

	crc32_partial(crc, s, len);

	(*crc) ^= 0xffffffff;
}
