
#include <syscalls/syscalls.h>

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "crc32.h"
int origin;

int chk_chr (const char* str, int chr) {
	while (*str && *str != chr) str++;
	return *str;
}

char *create_83_filename(char *path, char *filename) {
	char *p;
	char c, ord = 0x30;
	int i, si, di, ni, fd = 0;
	char sfn_name[13];
	i = 0;
	ni = 8;
	di = strlen(filename);
	while (di && filename[di - 1] != '.') di--;
	for (si = 0; filename[si] == ' ' || filename[si] == '.'; ++si);
	memset(sfn_name, 0, 13);
	for (;;) {
		c = filename[si++];
		if (!c) break;
		if (c == ' ' || (c == '.' && si != di)) {
			continue;
		}
		if (i >= ni || si == di) {
			if (ni == 12)
				break;
			if (si > di)
				break;
			sfn_name[i++] = '.';
			si = di; ni = 12;
			continue;
		}
		if (chk_chr("+,;=[]", c)) {
			c = '_';
		} else if (chk_chr("\"*:<>\?|\x7F/\\", c)) {
			fprintf(stderr, "Filename %s contains invalid character\n", filename);
			return NULL;
		} else if (c  >= 'a' && c <= 'z') {
			c -= 0x20;
		}
		sfn_name[i++] = c;
	}
	p = malloc(strlen(path) + strlen(sfn_name) + 2);
	if (p == NULL) {
		fprintf(stderr, "Out of memory on allocating 8.3 path\n");
		return NULL;
	}
	if (strlen(filename) > 12) {
		do {
			ord += 1;
			sfn_name[6] = '~';
			sfn_name[7] = ord;
			strcpy(p, path);
			strcat(p, "\\");
			strcat(p, sfn_name);
			fd = sys_open(p, FILE_RD);
			if (fd > 0)
				sys_close(fd);
		} while(fd > 0 && ord < 0x40);
	} else {
		strcpy(p, path);
		strcat(p, "\\");
		strcat(p, sfn_name);
	}
	return p;
}

void printxy(int x, int y, char *str, unsigned short flags)
{
	font_t fnt;
	fnt.w1 = 0;
	fnt.idx = 1;
	fnt.size = 0x10;
	fnt.style = flags;
	sys_printxy(x + origin, y, str, &fnt);
}

void copy_vram()
{
	sys_0x01(origin, 0, 0x210, 0x140);
}

void update_display(char *path)
{
	sys_0x07();
	printxy(0, 0, "Copy NAND to SD", 0x01);
	if (path) {
		printxy(32, 152, "Copying ", 0x00);
		printxy(96, 152, path, 0x00);
	}
	copy_vram();
}

void set_xorigin()
{
	void * hdr = (void *)0x8000ff80;
	if (memcmp(hdr, "CASIODICS", 9) == 0) {
		origin = 0;
	} else {
		origin = -48;
	}
}

unsigned int copy_file(char *src, char *dst, uint32_t *crc)
{
	long ret, ret2;
	char buffer[8192];
	int fd_in, fd_out;
	int sz_in;
	int sz_out;
	fd_in = sys_open(src, FILE_RD);
	if (fd_in < 0) {
		fprintf(stderr, "Failed to open src %s (%d)\n", src, fd_in);
		return 0;
	}
	ret = sys_create(dst, 1);
	if (ret < 0) {
		fprintf(stderr, "Failed to create file %s (%d)\n", dst, ret);
		sys_close(fd_in);
		return 0;
	}
	fd_out = sys_open(dst, FILE_WR);
	if (fd_out < 0) {
		fprintf(stderr, "Failed to open dst %s (%d)\n", dst, fd_out);
		sys_close(fd_in);
		return 0;
	}
	sys_seek(fd_in, 0, 0);
	sz_in = sys_get_filesize(fd_in);
	*crc = 0xffffffff;
	while((ret = sys_read(fd_in, buffer, 8192)) > 0) {
		crc32_partial(crc, buffer, ret);
		ret2 = sys_write(fd_out, buffer, ret);
		if (ret2 != ret) {
			fprintf(stderr, "File write error for %s (%d != %d)\n", dst, ret2, ret);
			break;
		}
	}
	if (ret < 0) {
		fprintf(stderr, "File read error for %s (%d)\n", src, ret);
	}
	sz_out = sys_get_filesize(fd_out);
	if (sz_in != sz_out) {
		fprintf(stderr, "File %s has a size mismach (%d != %d)\n", src, sz_in, sz_out);
	}
	sys_close(fd_in);
	sys_close(fd_out);
	*crc ^= 0xffffffff;
	return sz_in;
}

void copy_recursive(char *src, char *mask, char *dst)
{
	int ret, handle, sz;
	unsigned long type;
	char filemask[0x100];
	char filename[64];
	char *src1;
	char *dst1;
	uint32_t crc;
	if ((strlen(src) + strlen(mask) + 2) > 0x100) {
		fprintf(stderr, "filemask greater than 256 bytes");
		return;
	}
	strcpy(filemask, src);
	strcat(filemask, "\\");
	strcat(filemask, mask);
	fprintf(stderr, "Searching %s\n", filemask);
	ret = sys_findfirst(filemask, &handle, filename, &type);
	while (ret == 0) {
		src1 = malloc(strlen(src) + strlen(filename) + 5);
		if (src1 == 0) {
			fprintf(stderr, "Out of memory on allocate src1\n");
			break;
		}
		dst1 = create_83_filename(dst, filename);
		if (dst1) {
			strcpy(src1, src);
			strcat(src1, "\\");
			strcat(src1, filename);
			if (type == 5) {
				sys_create(dst1, type);
				copy_recursive(src1, mask, dst1);
				printf("d %s > %s 0:0\n", src1, dst1);
			} else if (type == 1) {
				update_display(src1);
				sz = copy_file(src1, dst1, &crc);
				printf("f %s > %s %u:%x\n", src1, dst1, sz, crc);
			} else {
				fprintf(stderr, "File %s has unknown type of %d\n", filename, type);
			}
		}
		ret = sys_findnext(handle, filename, &type);
		if (dst1) free(dst1);
		free(src1);
	}
	if (ret != -16)
		fprintf(stderr, "Find finished with code of %d\n", ret);
	sys_findclose(handle);
}

int main(void* ptr) {
	int ret, sz;
	uint32_t crc;
	unsigned long drv;
	char id[10];
	if (*((long*)ptr) == 1)
		return -1;
	fprintf(stderr, "Copying data0 -> crd0\n");
	sys_dict_info(&drv, id);
	if (drv != 0)
		return -2;
	sys_sdformat();
	ret = sys_create("\\\\crd0\\exists", 1);
	if (ret < 0)
		return -2;
	sys_delete("\\\\crd0\\exists");
	crc32_init();
	set_xorigin();
	update_display(0);
	copy_recursive("\\\\data0", "*.*", "\\\\crd0");
	return -2;
}

