#!/usr/bin/env python

# NAND FS Rename and Verify script (python2)
# This software is provided ‘as-is’, without any express or implied
# warranty. In no event will the authors be held liable for any damages
# arising from the use of this software.
# 
# Permission is granted to anyone to use this software for any purpose,
# including commercial applications, and to alter it and redistribute it
# freely, subject to the following restrictions:
# 
# 1. The origin of this software must not be misrepresented; you must not
# claim that you wrote the original software. If you use this software
# in a product, an acknowledgment in the product documentation would be
# appreciated but is not required.
# 
# 2. Altered source versions must be plainly marked as such, and must not be
# misrepresented as being the original software.
# 
# 3. This notice may not be removed or altered from any source
# distribution.


import re, zlib, sys, os, os.path, string
from optparse import OptionParser

parser = OptionParser(usage="usage: %prog [options] filename")
parser.add_option('-b', '--base', dest="base_dir", metavar='PATH', help='Directory containing files', default='./')

(options, args) = parser.parse_args()
if len(args) != 1:
  parser.print_help()
  sys.exit(1)


r = re.compile(r"^([d|f]) //data\d(/[^ ]+) > //crd\d(/[^ ]+) (\d+):([a-f0-9]+)$")
log = open(args[0], 'r')
for line in log:
    line = line.translate(string.maketrans('\\','/'))
    m = r.match(line)
    if m:
        kind = m.group(1)
        src = options.base_dir + m.group(3)
        dst = options.base_dir + m.group(2)
        size = int(m.group(4))
        crc32 = int(m.group(5), 16)
        if kind == 'd':
            try:
                os.rename(src, dst)
            except OSError as e:
                if e.errno == 2:
                    pass
        else:
            os.renames(src, dst)
            csize = os.path.getsize(dst)
            if size != csize:
                print "Size mismatch for %s (%d != %d)" % (dst, size, csize)
            ccrc32 = zlib.crc32(open(dst, "rb").read()) & 0xffffffff
            if crc32 != ccrc32:
                print "CRC mismatch for %s (%x != %x)" % (dst, crc32, ccrc32)
    else:
        print "line %s is invalid" % line

