
#include "exword.h"
#define NULL 0

struct r_hdr {
	char sig[12];
	char model[4];
	unsigned long magic;
	unsigned long nor_size;
};

int memcmp(const void *s1, const void *s2, unsigned long n)
{
	const unsigned char *us1 = (const unsigned char *) s1;
	const unsigned char *us2 = (const unsigned char *) s2;
	while (n-- != 0) {
		if (*us1 != *us2)
			return (*us1 < *us2) ? -1 : +1;
		++us1;
		++us2;
	}
	return 0;
}

void* memcpy(void* dest, const void* src, unsigned int count)
{
	char* dst8 = (char*)dest;
	char* src8 = (char*)src;

	while (count--) {
		*dst8++ = *src8++;
	}
	return dest;
}

char *strcpy(char *s1, const char *s2)
{
	char *p = s1;
	while (*s1++ = *s2++);
	return p;
}

unsigned int strlen(const char *s)
{
    unsigned int count = 0;
    while (*s++ != '\0')
        ++count;
    return count;
}

void get_filename(int drv, char* model, char* path)
{
	char *s = path;
	if(drv)
		strcpy(path, "\\\\crd0\\");
	else
		strcpy(path, "\\\\drv0\\");
	s += strlen(path);
	memcpy(s, model, 4);
	s += 4;
	strcpy(s, "_NOR.BIN");
}

struct r_hdr* get_r_hdr() {
	struct r_hdr *hdr;
	hdr = (struct r_hdr*)0x8000ff80;
	if (memcmp(hdr->sig, "CASIODICS", 9) == 0) {
		return hdr;
	}
	hdr = (struct r_hdr*)0x8001ff80;
	if (memcmp(hdr->sig, "CASIODICS", 9) == 0) {
		return hdr;
	}
	return NULL;
}

int main(void* ptr) {
	int fd;
	unsigned long drv;
	char  filename[25];
	char id[10];
	struct r_hdr *hdr = get_r_hdr();
	if (hdr == NULL)
		return -2;
	sys_dict_info(&drv, id);
	get_filename(drv, hdr->model, filename);
	sys_delete(filename);
	if (sys_create(filename, 1) == 0) {
		fd = sys_open(filename, 0x3);
		if (fd > 0) {
			sys_write(fd, (char *)0x80000000, hdr->nor_size);
			sys_close(fd);
		}
	}
	return -2;
}

