
#include <exword.h>
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>
#include <errno.h>

struct r_hdr {
	char sig[12];
	char model[4];
	unsigned long magic;
	unsigned long nor_size;
};

unsigned long GetPVR() {
	unsigned long *pvr = (unsigned long *)0xff000030;
	return *pvr;
}

char* get_path(int drv, char* name)
{
	char *s = malloc(8 + strlen(name));

	if(drv)
		strcpy(s, "\\\\crd0\\");
	else
		strcpy(s, "\\\\drv0\\");
	strcat(s, name);
	return s;
}

struct r_hdr* get_r_hdr() {
	struct r_hdr *hdr;
	hdr = (struct r_hdr*)0x8000ff80;
	if (memcmp(hdr->sig, "CASIODICS", 9) == 0) {
		return hdr;
	}
	hdr = (struct r_hdr*)0x8001ff80;
	if (memcmp(hdr->sig, "CASIODICS", 9) == 0) {
		return hdr;
	}
	return NULL;
}

unsigned long get_mem_size()
{
	int ret, model = 0;
	unsigned long size = 0;
	struct r_hdr *hdr = get_r_hdr();
	if (hdr != NULL) {
		if (hdr->model[0] == 'C') {
			model = atoi(hdr->model + 1);
			if (model >= 160)
				size = 0x1000000;
			else
				size = 0x800000;
		} else {
			size = 0x200000;
		}
	}
	return size;
}

int main(void* ptr) {
	int fd;
	unsigned long pvr;
	unsigned long ext_addr, ext_len, chip_addr;
	unsigned long drv;
	char *chip = NULL;
	char *external = NULL;
	char id[10];
	pvr = GetPVR();
	sys_dict_info(&drv, id);
	chip = get_path(drv, "CHIP.BIN");
	external = get_path(drv, "EXTERNAL.BIN");
	ext_len = get_mem_size();
	if(pvr == 0x10300B00) {
		ext_addr = 0x8c000000;
		chip_addr = 0xfd800000;
	} else {
		ext_addr = 0x88000000;
		chip_addr = 0xa5600000;
	}
	if (chip) {
		sys_delete(chip);
		if (sys_create(chip, 1) == 0) {
			fd = sys_open(chip, 0x2);
			if (fd > 0) {
				int sz = sys_write(fd, (char*)chip_addr, 0x4000);
				sys_close(fd);
			}
		}
	}
	if (external) {
		sys_delete(external);
		if (sys_create(external, 1) == 0) {
			fd = sys_open(external, 0x2);
			if (fd > 0) {
				int sz = sys_write(fd, (char*)ext_addr, ext_len);
				sys_close(fd);
			}
		}
	}
	free(chip);
	free(external);
	return -2;
}

