[English](readme.md) | [日本語](readme.ja.md) | [简体中文](readme.zh-Hans.md)

# 电子词典固件工具

本项目包含一系列用于处理卡西欧一些2010年代的历史型号电子词典（Casio Ex-Word）固件的脚本。这些电子词典通常是用SuperH处理器并且有 NOR 和 NAND 存储数据。您可以使用这些工具来备份、修改和重新打包 NOR 和 NAND 闪存镜像，以及在词典上运行自制程序。

## 目录结构

-   [`docs/`](./docs/): 包含项目相关的详细技术文档。
    -   [`fileformat.md`](./docs/fileformat.md): 附加词典所使用的各种文件格式的说明。
    -   [`interrupts.md`](./docs/interrupts.md): 关于中断、硬件寄存器、系统调用和通信协议的技术细节。
    -   [`model-and-addon-list.md`](./docs/model-and-addon-list.md): 型号和附加组件列表。
    -   [`nand-and-nor.md`](./docs/nand-and-nor.md): NAND 和 NOR 闪存布局、文件系统和刷机指南。
-   [`softwares/`](./softwares/): 包含用于 PC 和词典的各种工具软件。
    -   [`run-on-dictionary/`](./softwares/run-on-dictionary/): 可在词典上作为插件运行的程序。
        -   `copy_nand`: 用于完整复制 NAND 闪存中的所有文件。
        -   `MEM_dumper`: 用于转储内存（RAM）。
        -   `NOR_dumper`: 用于转储整个 NOR 闪存芯片。
    -   [`run-on-pc/`](./softwares/run-on-pc/): 在 PC 上运行的工具。
        -   [`flash-utilities/`](./softwares/run-on-pc/flash-utilities/): 处理 NOR 镜像的工具 (`nor_parse.py`, `nor_build.py` 等)。
        -   [`nand-build/`](./softwares/run-on-pc/nand-build/): 处理 NAND 镜像的工具 (`nand_build.py`, `layoutparser.py` 等)。
        -   [`resource-extract/`](./softwares/run-on-pc/resource-extract/): 提取词典资源文件的工具 (`gra_reader.py` 由 https://github.com/Waynefn/casio 改进而来)。

## PC 端工具使用详解

### NOR 闪存工具 (`softwares/run-on-pc/flash-utilities/`)

这些工具用于处理 NOR 固件镜像。

-   **`nor_parse.py` - 解包和分析 NOR 固件**
    -   **功能**: 解析 NOR 固件镜像，验证校验和，并提取内容。
    -   **用法**: `python nor_parse.py [选项] <固件文件.BIN>`
    -   **常用选项**:
        -   `-e`, `--extract`: 提取文件系统到 `tmp-output/<固件名>/content` 目录，并将固件头等元数据存放到 `tmp-output/<固件名>/metadata`。这是修改固件的第一步。
        -   `-s`, `--short`: 只显示型号等基本信息，不输出完整的技术细节。
    -   **示例**: `python nor_parse.py -e CY123OSB.BIN`

-   **`nor_build.py` - 重建 NOR 固件**
    -   **功能**: 从提取的文件和元数据重新构建 NOR 固件镜像。
    -   **用法**: `python nor_build.py [选项] <输入目录> <输出固件.BIN>`
    -   **说明**: `<输入目录>` 必须是 `nor_parse.py -e` 生成的包含 `content` 和 `metadata` 的目录。
    -   **常用选项**:
        -   `-r`, `--allow-relocate`: **高级功能**。允许添加、删除或重定位文件。当修改后的文件大于原始空间时，此选项会尝试寻找可用空间进行重排。
    -   **示例**: `python nor_build.py ./tmp-output/CY123OSB my_modified_firmware.BIN`

-   **`nor_patch.py` - 为固件打补丁**
    -   **功能**: 直接修改 NOR 固件以解锁Test Menu中需要密码进入的目录。
    -   **注意**: 此脚本会**直接修改输入文件**。
    -   **用法**: `python nor_patch.py <固件文件.BIN>`
    -   **示例**: `python nor_patch.py CY123OSB-original.BIN`

-   **`nor_decrypt.py` - 解密固件**
    -   **功能**: 解密一些更新包中加密 NOR 固件（如果 NOR 固件能用上面的`nor_parse.py`说明已解密）。
    -   **用法**: `python nor_decrypt.py <加密固件.BIN> <解密后固件.BIN>`
    -   **示例**: `python nor_decrypt.py encrypted.BIN decrypted.BIN`

-   **`nor_chksums.py` / `nand_chksums.py` - 校验和验证**
    -   **功能**: 独立验证 NOR 或 NAND 镜像的完整性。
    -   **用法**: `python <脚本名>.py <固件文件.BIN>`

### NAND 闪存工具 (`softwares/run-on-pc/nand-build/`)

这些工具用于创建和解析 NAND 刷机镜像。

-   **`nand_build.py` - 构建 NAND 刷机镜像**
    -   **功能**: 从指定目录中的文件和布局配置构建一个完整的 NAND 刷机镜像。
    -   **用法**: `python nand_build.py [选项] <源文件目录> <输出镜像.bin>`
    -   **常用选项**:
        -   `-l`, `--layout`: **必需**。指定 NAND 布局（如 `dp5`），对应 `_layouts/` 目录下的配置文件。
        -   `-m`, `--model`: **必需**。设置词典型号（如 `C126`）。
        -   `-e`, `--ext-model`: 设置扩展型号（如 `CY126`）。
        -   `-v`, `--version`: 设置数据版本号（十六进制 BCD 码，如 `0x100`）。
        -   `-t`, `--timestamp`: 自定义固件时间戳（格式："YYYY/MM/DD HH:MM:SS"）。
    -   **示例**: `python nand_build.py --layout dp5 --model C126 --ext-model CY126 ./my_nand_files CY126D0C.bin`

-   **`nand_parse.py` - 解析 NAND 刷机镜像**
    -   **功能**: 解包 `nand_build.py` 生成的镜像，提取文件并分析其构建参数。
    -   **用法**: `python nand_parse.py <输入镜像.bin> <输出目录> [选项]`
    -   **常用选项**:
        -   `--detect`: 仅检测并打印用于构建此镜像的布局 `.ini` 文件。
        -   `--verify`: 仅验证镜像的校验和，不提取文件。
    -   **示例**: `python nand_parse.py CY126D0C.bin ./extracted_nand_files`

### 在词典上运行自制程序

[`softwares/run-on-dictionary/`](./softwares/run-on-dictionary/) 目录中的程序可以作为插件安装到词典上，用于提取固件和数据。

-   `copy_nand`: 用于备份 NAND 芯片中文件夹和文件内容，这些文件和文件夹可通过`nand_build.py`制作 NAND 刷机镜像。另外通过 Test Menu 的 `DATAOUT` 功能也能备份 NAND ，但是推荐使用此工具从词典复制 NAND 文件系统的内容，因为通过 Test Menu 的 `DATAOUT` 功能导出的数据可能包含随机错误。
-   `NOR_dumper`: 用于备份 NOR 芯片内容，其转储文件可用于制作 NOR 刷机镜像。

### 刷机指南

刷机流程需要在词典的工程模式（Test Menu）下进行。

1.  **进入 Test Menu**:
    1.  确保词典处于**关机**状态。
    2.  同时按住 **退出 + 上翻页 + 电源键** 约五秒钟，直到屏幕亮起并显示 "Model" 窗口。
    3.  松开按键，然后按 **两下右键**，再按 **输入键** 即可进入菜单。

2.  **准备 TF 卡**: 在 Test Menu 中选择相应选项，格式化一张 TF 卡（推荐 2GB）。

3.  **准备固件文件**:
    -   你可以用上面的自制程序和脚本自己从词典上备份制作固件，也可以用别人分享的固件，对于硬件一样的机型的固件可以互相通用。
    -   **NOR 固件**: 使用`NOR_dumper`备份并修剪成 NOR 镜像，或找别人分享的 NOR 镜像。将其重命名（例如 `CY123OSB.BIN`）并复制到 TF 卡根目录。
    -   **NAND 固件** (可选): 使用`copy_nand` 备份然后用 `nand_build.py` 构建成 NAND 镜像，或找别人分享的 NAND 镜像 (例如 `CY123D0B.bin`)，并复制到 TF 卡根目录。
    -   **更新程序**: 用`nor_parse.py`从 NOR 镜像中提取 `UPDADN2.BIN` 或 `UPDADN3.BIN`，并复制到 TF 卡根目录（`UPDADN2.BIN`可能是用于文件名LY开头的系列的固件的更新程序，`UPDADN3.BIN`可能是用于文件名CY开头的新一些型号）。

4.  **开始刷机**:
    -   将包含上述文件的 TF 卡插入词典。
    -   在 Test Menu 中选择 `OS UPDATE` 或相应选项开始刷机流程。

> **注意**: 刷机有风险，请务必备份您的数据，具体适用的词典型号请自行尝试。更详细的刷机步骤、Test Menu 功能说明和技术细节，请参阅 [**`docs/nand-and-nor.md`**](./docs/nand-and-nor.md)。

## 未来研究方向

1.  **虚拟机**: 在电脑上用QEMU或类似技术制作词典的虚拟机，方便动态调试分析。
2.  **解析资源文件**: 目前还不知道词典资源文件是什么格式，希望网上社区大家一起努力解析出词典文件格式。
