[English](readme.md) | [日本語](readme.ja.md) | [简体中文](readme.zh-Hans.md)

# Electronic Dictionary Firmware Tools

This project contains a set of scripts for working with the firmware of some historical Casio electronic dictionaries (Casio Ex-Word) from the 2010s. These dictionaries typically used SuperH processors and had NOR and NAND flash memory for data storage. You can use these tools to back up, modify, and repack NOR and NAND flash images, as well as run custom programs on the dictionaries.

## Directory Structure

-   [`docs/`](./docs/): Contains detailed technical documentation related to the project.
    -   [`fileformat.md`](./docs/fileformat.md): Descriptions of various file formats used by add-on dictionaries.
    -   [`interrupts.md`](./docs/interrupts.md): Technical details on interrupts, hardware registers, system calls, and communication protocols.
    -   [`model-and-addon-list.md`](./docs/model-and-addon-list.md): A list of models and add-ons.
    -   [`nand-and-nor.md`](./docs/nand-and-nor.md): NAND and NOR flash layouts, file systems, and flashing guides.
-   [`softwares/`](./softwares/): Contains various tool software for PC and the dictionary.
    -   [`run-on-dictionary/`](./softwares/run-on-dictionary/): Programs that can be run as add-ons on the dictionary.
        -   `copy_nand`: Used to completely copy all files from the NAND flash.
        -   `MEM_dumper`: Used to dump memory (RAM).
        -   `NOR_dumper`: Used to dump the entire NOR flash chip.
    -   [`run-on-pc/`](./softwares/run-on-pc/): Tools that run on a PC.
        -   [`flash-utilities/`](./softwares/run-on-pc/flash-utilities/): Tools for handling NOR images (`nor_parse.py`, `nor_build.py`, etc.).
        -   [`nand-build/`](./softwares/run-on-pc/nand-build/): Tools for handling NAND images (`nand_build.py`, `layoutparser.py`, etc.).
        -   [`resource-extract/`](./softwares/run-on-pc/resource-extract/): Tools for extracting dictionary resource files (`gra_reader.py` is improved from https://github.com/Waynefn/casio ).

## PC Tools Usage Details

### NOR Flash Tools (`softwares/run-on-pc/flash-utilities/`)

These tools are for processing NOR firmware images.

-   **`nor_parse.py` - Unpack and Analyze NOR Firmware**
    -   **Function**: Parses a NOR firmware image, verifies checksums, and extracts its contents.
    -   **Usage**: `python nor_parse.py [options] <firmware_file.BIN>`
    -   **Common Options**:
        -   `-e`, `--extract`: Extracts the file system to the `tmp-output/<firmware_name>/content` directory and stores metadata like the firmware header in `tmp-output/<firmware_name>/metadata`. This is the first step to modifying the firmware.
        -   `-s`, `--short`: Displays only basic information like the model number, without outputting full technical details.
    -   **Example**: `python nor_parse.py -e CY123OSB.BIN`

-   **`nor_build.py` - Rebuild NOR Firmware**
    -   **Function**: Rebuilds a NOR firmware image from extracted files and metadata.
    -   **Usage**: `python nor_build.py [options] <input_directory> <output_firmware.BIN>`
    -   **Note**: The `<input_directory>` must be the directory generated by `nor_parse.py -e`, containing `content` and `metadata`.
    -   **Common Options**:
        -   `-r`, `--allow-relocate`: **Advanced feature**. Allows adding, deleting, or relocating files. If a modified file is larger than its original space, this option will try to find available space to rearrange it.
    -   **Example**: `python nor_build.py ./tmp-output/CY123OSB my_modified_firmware.BIN`

-   **`nor_patch.py` - Patch Firmware**
    -   **Function**: Directly modifies the NOR firmware to unlock password-protected directories in the Test Menu.
    -   **Caution**: This script **modifies the input file directly**.
    -   **Usage**: `python nor_patch.py <firmware_file.BIN>`
    -   **Example**: `python nor_patch.py CY123OSB-original.BIN`

-   **`nor_decrypt.py` - Decrypt Firmware**
    -   **Function**: Decrypts encrypted NOR firmware found in some update packages (if `nor_parse.py` can read the firmware, it's already decrypted).
    -   **Usage**: `python nor_decrypt.py <encrypted_firmware.BIN> <decrypted_firmware.BIN>`
    -   **Example**: `python nor_decrypt.py encrypted.BIN decrypted.BIN`

-   **`nor_chksums.py` / `nand_chksums.py` - Checksum Verification**
    -   **Function**: Independently verifies the integrity of a NOR or NAND image.
    -   **Usage**: `python <script_name>.py <firmware_file.BIN>`

### NAND Flash Tools (`softwares/run-on-pc/nand-build/`)

These tools are for creating and parsing NAND flashing images.

-   **`nand_build.py` - Build NAND Flashing Image**
    -   **Function**: Builds a complete NAND flashing image from files in a specified directory and a layout configuration.
    -   **Usage**: `python nand_build.py [options] <source_files_directory> <output_image.bin>`
    -   **Common Options**:
        -   `-l`, `--layout`: **Required**. Specifies the NAND layout (e.g., `dp5`), corresponding to a config file in the `_layouts/` directory.
        -   `-m`, `--model`: **Required**. Sets the dictionary model (e.g., `C126`).
        -   `-e`, `--ext-model`: Sets the extended model (e.g., `CY126`).
        -   `-v`, `--version`: Sets the data version number (in hex BCD, e.g., `0x100`).
        -   `-t`, `--timestamp`: Custom firmware timestamp (format: "YYYY/MM/DD HH:MM:SS").
    -   **Example**: `python nand_build.py --layout dp5 --model C126 --ext-model CY126 ./my_nand_files CY126D0C.bin`

-   **`nand_parse.py` - Parse NAND Flashing Image**
    -   **Function**: Unpacks an image created by `nand_build.py`, extracting files and analyzing its build parameters.
    -   **Usage**: `python nand_parse.py <input_image.bin> <output_directory> [options]`
    -   **Common Options**:
        -   `--detect`: Only detects and prints the layout `.ini` file used to build this image.
        -   `--verify`: Only verifies the image's checksums without extracting files.
    -   **Example**: `python nand_parse.py CY126D0C.bin ./extracted_nand_files`

### Running Homebrew on the Dictionary

Programs in the [`softwares/run-on-dictionary/`](./softwares/run-on-dictionary/) directory can be installed as add-ons on the dictionary to extract firmware and data.

-   `copy_nand`: Used to back up the folders and file contents in the NAND chip, which can be used by `nand_build.py` to create a NAND flashing image. The `DATAOUT` function in the Test Menu can also back up the NAND, but it is recommended to use this tool to copy the NAND file system contents from the dictionary, as data exported via `DATAOUT` may contain random errors.
-   `NOR_dumper`: Used to back up the NOR chip content. Its dump file can be used to create a NOR flashing image.

### Flashing Guide

The flashing process is performed in the dictionary's engineering mode (Test Menu).

1.  **Enter Test Menu**:
    1.  Ensure the dictionary is **powered off**.
    2.  Press and hold **Exit + Page Up + Power** for about five seconds until the screen turns on and displays a "Model" window.
    3.  Release the keys, then press the **Right key twice**, and then press the **Enter key** to enter the menu.

2.  **Prepare TF Card**: Select the corresponding option in the Test Menu to format a TF card (2GB recommended).

3.  **Prepare Firmware Files**:
    -   You can use the homebrew programs and scripts mentioned above to back up and create firmware from your own dictionary, or use firmware shared by others. Firmware from models with the same hardware is generally interchangeable.
    -   **NOR Firmware**: Back up with `NOR_dumper` and trim it into a NOR image, or find a NOR image shared by others. Rename it (e.g., `CY123OSB.BIN`) and copy it to the root of the TF card.
    -   **NAND Firmware** (Optional): Back up with `copy_nand` and then build a NAND image with `nand_build.py`, or find a NAND image shared by others (e.g., `CY123D0B.bin`), and copy it to the root of the TF card.
    -   **Updater Program**: Extract `UPDADN2.BIN` or `UPDADN3.BIN` from the NOR image using `nor_parse.py` and copy it to the root of the TF card (`UPDADN2.BIN` is likely for firmware series with filenames starting with LY, while `UPDADN3.BIN` is for newer models with filenames starting with CY).

4.  **Start Flashing**:
    -   Insert the TF card containing the above files into the dictionary.
    -   Select `OS UPDATE` or the corresponding option in the Test Menu to start the flashing process.

> **Note**: Flashing carries risks. Be sure to back up your data and try it on your specific model at your own risk. For more detailed flashing steps, Test Menu function descriptions, and technical details, please refer to [**`docs/nand-and-nor.md`**](./docs/nand-and-nor.md).

## Future Research Directions

1.  **Virtual Machine**: Create a virtual machine of the dictionary on a PC using QEMU or similar technology for dynamic debugging and analysis.
2.  **Parse Resource Files**: The format of the dictionary's resource files is currently unknown. It is hoped that the online community will work together to parse the dictionary file formats.
