[English](readme.md) | [日本語](readme.ja.md) | [简体中文](readme.zh-Hans.md)

# 電子辞書ファームウェアツール

このプロジェクトには、2010年代のカシオ電子辞書（Casio Ex-Word）のファームウェアを操作するためのスクリプト一式が含まれています。これらの辞書は、通常SuperHプロセッサを搭載し、データ保存用にNOR型およびNAND型フラッシュメモリを搭載していました。これらのツールを使用することで、NOR型およびNAND型フラッシュメモリのイメージをバックアップ、変更、再パックしたり、辞書上でカスタムプログラムを実行したりできます。

## ディレクトリ構造

-   [`docs/`](./docs/): プロジェクトに関連する詳細な技術文書が含まれています。
    -   [`fileformat.md`](./docs/fileformat.md): 追加コンテンツで使用される様々なファイル形式の説明。
    -   [`interrupts.md`](./docs/interrupts.md): 割り込み、ハードウェアレジスタ、システムコール、通信プロトコルに関する技術的な詳細。
    -   [`model-and-addon-list.md`](./docs/model-and-addon-list.md): モデルと追加コンテンツのリスト。
    -   [`nand-and-nor.md`](./docs/nand-and-nor.md): NANDおよびNORフラッシュのレイアウト、ファイルシステム、書き込みガイド。
-   [`softwares/`](./softwares/): PCおよび辞書用の各種ツールソフトウェアが含まれています。
    -   [`run-on-dictionary/`](./softwares/run-on-dictionary/): 辞書上でアドオンとして実行可能なプログラム。
        -   `copy_nand`: NANDフラッシュ内の全ファイルを完全にコピーするために使用します。
        -   `MEM_dumper`: メモリ（RAM）をダンプするために使用します。
        -   `NOR_dumper`: NORフラッシュチップ全体をダンプするために使用します。
    -   [`run-on-pc/`](./softwares/run-on-pc/): PC上で実行するツール。
        -   [`flash-utilities/`](./softwares/run-on-pc/flash-utilities/): NORイメージを処理するツール（`nor_parse.py`、`nor_build.py`など）。
        -   [`nand-build/`](./softwares/run-on-pc/nand-build/): NANDイメージを処理するツール（`nand_build.py`、`layoutparser.py`など）。
        -   [`resource-extract/`](./softwares/run-on-pc/resource-extract/): 辞書リソース ファイルを抽出するツール （`gra_reader.py` は https://github.com/Waynefn/casio から改良されています）。

## PCツールの使用方法詳細

### NORフラッシュツール (`softwares/run-on-pc/flash-utilities/`)

これらのツールはNORファームウェアイメージを処理するために使用します。

-   **`nor_parse.py` - NORファームウェアの展開と分析**
    -   **機能**: NORファームウェアイメージを解析し、チェックサムを検証し、内容を抽出します。
    -   **使用法**: `python nor_parse.py [オプション] <ファームウェアファイル.BIN>`
    -   **主なオプション**:
        -   `-e`, `--extract`: ファイルシステムを`tmp-output/<ファームウェア名>/content`ディレクトリに抽出し、ファームウェアヘッダなどのメタデータを`tmp-output/<ファームウェア名>/metadata`に保存します。これはファームウェアを変更する最初のステップです。
        -   `-s`, `--short`: モデル番号などの基本情報のみを表示し、完全な技術的詳細は出力しません。
    -   **例**: `python nor_parse.py -e CY123OSB.BIN`

-   **`nor_build.py` - NORファームウェアの再構築**
    -   **機能**: 抽出されたファイルとメタデータからNORファームウェアイメージを再構築します。
    -   **使用法**: `python nor_build.py [オプション] <入力ディレクトリ> <出力ファームウェア.BIN>`
    -   **説明**: `<入力ディレクトリ>`は`nor_parse.py -e`で生成された`content`と`metadata`を含むディレクトリでなければなりません。
    -   **主なオプション**:
        -   `-r`, `--allow-relocate`: **高度な機能**。ファイルの追加、削除、再配置を許可します。変更後のファイルが元のスペースより大きい場合、このオプションは利用可能なスペースを探して再配置を試みます。
    -   **例**: `python nor_build.py ./tmp-output/CY123OSB my_modified_firmware.BIN`

-   **`nor_patch.py` - ファームウェアへのパッチ適用**
    -   **機能**: NORファームウェアを直接変更し、Test Menuでパスワードが必要なディレクトリのロックを解除します。
    -   **注意**: このスクリプトは**入力ファイルを直接変更します**。
    -   **使用法**: `python nor_patch.py <ファームウェアファイル.BIN>`
    -   **例**: `python nor_patch.py CY123OSB-original.BIN`

-   **`nor_decrypt.py` - ファームウェアの復号**
    -   **機能**: 一部の更新パッケージに含まれる暗号化されたNORファームウェアを復号します（`nor_parse.py`でファームウェアが読み取れる場合、それは既に復号済みです）。
    -   **使用法**: `python nor_decrypt.py <暗号化ファームウェア.BIN> <復号後ファームウェア.BIN>`
    -   **例**: `python nor_decrypt.py encrypted.BIN decrypted.BIN`

-   **`nor_chksums.py` / `nand_chksums.py` - チェックサム検証**
    -   **機能**: NORまたはNANDイメージの完全性を個別に検証します。
    -   **使用法**: `python <スクリプト名>.py <ファームウェアファイル.BIN>`

### NANDフラッシュツール (`softwares/run-on-pc/nand-build/`)

これらのツールはNAND書き込みイメージの作成と解析に使用します。

-   **`nand_build.py` - NAND書き込みイメージの構築**
    -   **機能**: 指定されたディレクトリ内のファイルとレイアウト設定から完全なNAND書き込みイメージを構築します。
    -   **使用法**: `python nand_build.py [オプション] <ソースファイルディレクトリ> <出力イメージ.bin>`
    -   **主なオプション**:
        -   `-l`, `--layout`: **必須**。NANDレイアウト（例：`dp5`）を指定します。これは`_layouts/`ディレクトリ内の設定ファイルに対応します。
        -   `-m`, `--model`: **必須**。辞書のモデル（例：`C126`）を設定します。
        -   `-e`, `--ext-model`: 拡張モデル（例：`CY126`）を設定します。
        -   `-v`, `--version`: データバージョン番号（16進BCDコード、例：`0x100`）を設定します。
        -   `-t`, `--timestamp`: カスタムファームウェアのタイムスタンプ（形式："YYYY/MM/DD HH:MM:SS"）。
    -   **例**: `python nand_build.py --layout dp5 --model C126 --ext-model CY126 ./my_nand_files CY126D0C.bin`

-   **`nand_parse.py` - NAND書き込みイメージの解析**
    -   **機能**: `nand_build.py`で生成されたイメージを展開し、ファイルを抽出してビルドパラメータを分析します。
    -   **使用法**: `python nand_parse.py <入力イメージ.bin> <出力ディレクトリ> [オプション]`
    -   **主なオプション**:
        -   `--detect`: このイメージのビルドに使用されたレイアウト`.ini`ファイルを検出して表示するだけです。
        -   `--verify`: ファイルを抽出せずにイメージのチェックサムのみを検証します。
    -   **例**: `python nand_parse.py CY126D0C.bin ./extracted_nand_files`

### 辞書上での自作プログラムの実行

[`softwares/run-on-dictionary/`](./softwares/run-on-dictionary/)ディレクトリ内のプログラムは、辞書にアドオンとしてインストールし、ファームウェアやデータを抽出するために使用できます。

-   `copy_nand`: NANDチップ内のフォルダとファイルの内容をバックアップするために使用します。これらのファイルは`nand_build.py`でNAND書き込みイメージを作成するために使用できます。また、Test Menuの`DATAOUT`機能でもNANDをバックアップできますが、`DATAOUT`経由でエクスポートされたデータにはランダムなエラーが含まれる可能性があるため、このツールを使用して辞書からNANDファイルシステムの内容をコピーすることをお勧めします。
-   `NOR_dumper`: NORチップの内容をバックアップするために使用します。そのダンプファイルはNOR書き込みイメージの作成に使用できます。

### 書き込みガイド

書き込みプロセスは、辞書のエンジニアリングモード（Test Menu）で行う必要があります。

1.  **Test Menuに入る**:
    1.  辞書が**電源オフ**の状態であることを確認します。
    2.  **終了 + ページアップ + 電源キー**を約5秒間押し続け、画面が点灯して「Model」ウィンドウが表示されるまで待ちます。
    3.  キーを離し、**右キーを2回**押し、次に**入力キー**を押してメニューに入ります。

2.  **TFカードの準備**: Test Menuで対応するオプションを選択し、TFカード（2GB推奨）をフォーマットします。

3.  **ファームウェアファイルの準備**:
    -   上記の自作プログラムとスクリプトを使用して、自分の辞書からファームウェアをバックアップして作成するか、他の人が共有したファームウェアを使用できます。同じハードウェアのモデルのファームウェアは、通常、相互に交換可能です。
    -   **NORファームウェア**: `NOR_dumper`でバックアップし、NORイメージにトリミングするか、他の人が共有したNORイメージを見つけます。ファイル名を変更し（例：`CY123OSB.BIN`）、TFカードのルートディレクトリにコピーします。
    -   **NANDファームウェア**（オプション）: `copy_nand`でバックアップしてから`nand_build.py`でNANDイメージをビルドするか、他の人が共有したNANDイメージ（例：`CY123D0B.bin`）を見つけて、TFカードのルートディレクトリにコピーします。
    -   **アップデータプログラム**: `nor_parse.py`を使用してNORイメージから`UPDADN2.BIN`または`UPDADN3.BIN`を抽出し、TFカードのルートディレクトリにコピーします（`UPDADN2.BIN`はファイル名がLYで始まるシリーズのファームウェア用、`UPDADN3.BIN`はファイル名がCYで始まる新しいモデル用と思われます）。

4.  **書き込み開始**:
    -   上記のファイルを含むTFカードを辞書に挿入します。
    -   Test Menuで`OS UPDATE`または対応するオプションを選択して、書き込みプロセスを開始します。

> **注意**: 書き込みにはリスクが伴います。必ずデータをバックアップし、ご自身の責任で特定のモデルでお試しください。より詳細な書き込み手順、Test Menuの機能説明、技術的な詳細については、[**`docs/nand-and-nor.md`**](./docs/nand-and-nor.md)を参照してください。

## 今後の研究課題

1.  **仮想マシン**: PC上でQEMUなどの技術を用いて辞書の仮想マシンを作成し、動的なデバッグと分析を容易にする。
2.  **リソースファイルの解析**: 現在、辞書のリソースファイルの形式は不明です。オンラインコミュニティが協力して辞書ファイル形式を解析することが期待されます。
