[English](nand-and-nor.md) | [日本語](nand-and-nor.ja.md) | [简体中文](nand-and-nor.zh-Hans.md)

# NANDとNORフラッシュメモリ

このドキュメントでは、NANDおよびNORフラッシュで使用されるファイルシステム形式について説明します。主な違いは、NORがブロックアドレッシングを使用しない点です。したがって、このドキュメントにおけるブロックに関するすべての記述は、NORメモリ内のバイトアドレスとして理解できます。

## NANDフラッシュ更新イメージ

NANDフラッシュ更新イメージには、2つのヘッダと、内蔵辞書のデータファイルの大部分を保持する読み取り専用ファイルシステムが含まれています。実際のNANDフラッシュチップ上には小さなFAT16ファイルシステムも存在し、コンピュータから転送されたファイルや追加コンテンツがここに保存されますが、これはNAND更新イメージの一部ではありません。

`nand_build`は、ファイルリストとNANDレイアウト記述に基づいてNAND書き込み用の更新イメージを作成できるNAND構築ツールです。現在のバージョンでは、DP4、DP5、およびDP6デバイス用のレイアウトが定義されています。

### レイアウト

#### ヘッダ1 (Header 1)

更新イメージには、実際には`hdr1`のコピーが2つ保存されています。1つ目はオフセット`0`にあり、2つ目はオフセット`(hdr1.hdr1_2_blk * hdr1.blocksize)`にあります。

```c
struct hdr1 {
    char signature[12];    // CASIOPVOS???
    uint16_t magic;        // 0x55AA
    uint16_t blocksize ;   // ブロックあたりのバイト数（常に0x200）
    uint32_t flash_nblks;  //
    uint32_t update_nblks; //
    uint32_t dword18;      // 常に0
    uint32_t hdr1_2_blk;   // hdr1の2番目のコピーのブロック番号
    uint32_t dir_blk;      // ディレクトリの開始ブロック
    uint32_t dir_nblks;    // ディレクトリのブロック長
    uint32_t hdr2_blk;     // 2番目のヘッダのブロック
    uint32_t hdr1_2_cpy;   // hdr1の2番目のコピーのブロック番号?? 常にhdr1_2_blkと同じ
    uint32_t dword30;      // 常に0xffffffff
    uint32_t dword34;      // 常に0xffffffff
    uint32_t dword38;      //
    uint32_t dword3C;      //
    uint32_t dword40;      // 常に0
    uint32_t dword44;      //
    char model[4];         // 4文字のモデル文字列
    uint32_t dword4C;      //
    uint32_t img_len;      // OS更新イメージファイルのブロック長
    uint32_t dword54;      //
    uint32_t dword58;      //
    uint32_t dword5C;      //
    uint32_t dword60;      //
    uint32_t dword64;      //
    char ext_model[8];     // 拡張モデル文字列 - DP5+のみ、DP5以前は0xffで埋められる
    char filler70[398];    //
    uint16_t checksum;     // 16ビットヘッダチェックサム
};
```

#### ヘッダ2 (Header 2)

NANDチェックサム（`datachksum`）は、`hdr2`以降からファイルの終わりまでのすべてのバイトを合計して計算されます。これを利用して、書き込み用にカスタムまたは変更されたNANDイメージを作成できます。`nand_chksums.py`ツールを使用してNANDチェックサムを確認できます。

```c
struct hdr2 {
    char signature[12];    // CASIOPVOS???
    uint32_t dwordC;       // 常に0
    uint32_t dword10;      // 常に0
    uint32_t dword14;      // 常に0xffffffff
    char model[4];         // モデル文字列
    char datetime[8];      // 日時（BCDエンコード）
    uint16_t version;      // バージョン番号（BCDエンコード）
    char padding[2];       // パディング、ゼロであるべき
    uint32_t dword28;      // 常に0
    uint32_t datachksum;   // NANDチェックサム - hdr2以降の全バイトの合計
    char ext_model[8];     // 拡張モデル文字列 - DP5+のみ、DP5以前は0xffで埋められる
    char filler2C[454];    //
    uint16_t checksum;     // 16ビットヘッダチェックサム
};
```

### NANDフォルダディレクトリ構造

以下は、NANDで見つかったフォルダとその推定される機能のリストです。`cz???`（中国モデル）のようなほとんどのフォルダは辞書フォルダです。

-   `ttslib`: 富士通（FUJITSU LIMITED 1994）のテキスト読み上げライブラリ。音声合成辞書に使用され、11.025 kHz 16bit形式です。
-   `txtv`: 不明。
-   `voice`: 辞書の音声ファイル。
-   `henka`: 「henka」（変化）は日本語で変化、変換を意味します。このフォルダを削除すると、内蔵辞書の「あいまい検索」が「キャンセルされました」と表示されます。
-   `fukuE`: 「fuku」（副）は副詞または副次的な機能を指す可能性があります。英語の単語の「ジャンプ検索」（左上の3番目のボタン）に使用されます。削除すると、英語の単語でジャンプすると「マイライブラリ」に移動します。
-   `fukuJ`: 中国語または日本語の単語の「ジャンプ検索」に使用されます。
-   `font`: `.cjf`フォントファイルを格納しており、ダンプ可能です。
-   `czMDE`: 中国モデルで見つかります。機能メニューの「多辞書英語検索」の可能性があります。
-   `czMDJ`: 中国モデルで見つかります。機能メニューの「多辞書日本語検索」の可能性があります。
-   `libr`: 不明。
-   `menu_cn`: 中国語メニューリソース。削除すると、メニュー表示は空白になりますが、機能は有効です。
-   `menu_jp`: 日本語メニューリソース。
-   `menu_en`: 英語メニューリソース。
-   `sys`: システムフォルダ？
-   `demo`: 中国モデルでは、このフォルダは空です。

## TJFSファイルシステム

NAND ROMで使用されるファイルシステム（推定「TJFS」）は、読み取り専用であり、ROMに書き込まれた後は変更をサポートしないため、非常にシンプルです。ファイルシステムが読み取り専用であるため、ファイルは連続したブロックに保存され、ファイルの断片化は存在しません。ファイルシステムのルートディレクトリにはディレクトリのみを含めることができ、ネストされたディレクトリは許可されません。

### マスターディレクトリテーブル (Master Directory Table)

このテーブルには、ファイルシステム内のすべてのファイルとディレクトリのリストが含まれています。各エントリは32バイト長で、最初にディレクトリがリストされ、次に各ディレクトリに含まれるすべてのファイルが続きます。すべての値はビッグエンディアン形式で保存されます。

```c
struct DirEntry {
    char filename[16];
    /*
     * ディレクトリまたはファイルの名前を含むヌル終端文字列。
     */
    short dir_id;
    /*
     * ファイルの場合、この値は常に0xffffです。
     * ディレクトリの場合、これはファイルをディレクトリに関連付けるための一意のIDです。
     */
    short dir_ptr;
    /*
     * ディレクトリの場合、この値は常に0xffffです。
     * ファイルの場合、この値はそれが含まれるディレクトリのdir_idを指します。
     */
    unsigned long location;
    /*
     * エントリがディレクトリの場合、このフィールドはマスターディレクトリテーブルへの0から始まるインデックスであり、
     * そのディレクトリのファイルリストの開始位置を示します。
     * エントリがファイルの場合、このフィールドはファイルの開始ブロック番号（ブロックサイズは512バイト）を示します。
     */
    unsigned long size;
    /*
     * ファイルのバイト単位のサイズ。ディレクトリの場合、この値は常に0です。
     */
    unsigned long flags;
    /*
     * エントリのフラグフィールド。有効な値は現在不明です。
     */
};
```

## テストメニュー (Test Menu)

カシオの電子辞書には、隠されたエンジニアリングモード（Test Menu）があります。

**入り方:**
1.  電源を切ります。
2.  **終了 + ページアップ + 電源キー**を約5秒間押し続け、画面に「Model」と表示されたウィンドウが現れるまで待ちます。
3.  キーを離し、**右キーを2回**押し、次に**入力キー**を押します。

### メニューオプションの説明

-   **TJFS物理フォーマット (TJFS Physical Format)**: パスワードが必要です。TJFSファイルシステムのクイックフォーマットを実行するようです。実行後、デバイスは起動時に「お待ちください…」画面で停止します。
-   **強制ディープフォーマット (Force Strong Format)**: NANDを消去します。パスワードを入力した後、3つのオプションがあります：
    -   `NACE1`: `0000`から`0FFF`までを消去します。プロセスは遅く、ブロックごとに行われます。不良ブロック数が表示されることがあります。
    -   `NACE2`: 一部のデバイスで「CAPA NG」と表示されます。
    -   `NACE3`: 正常に動作しないようです。
    実行後、起動時に「エラーコード01」が表示されることがあります。奇妙なことに、フォーマット後もデバイスは正常に起動するようで、この機能の具体的な役割は不明です。
-   **データ書き込み (DATA IN)**: パスワードが必要です。TFカード上の`DATAOUT.BIN`ファイルからNANDに書き込みます。消去エラー（不良ブロックが原因の可能性があります）が発生すると、プロセスは停止し、起動時にエラーコードが表示される原因となることがあります。
-   **データエクスポート (DATA OUT)**: NANDからTFカードにデータをエクスポートし、`DATAOUT.BIN`ファイルを作成します。エクスポートされたデータには、ECC（誤り訂正符号）で修正できなかったランダムなビット反転エラーが含まれる可能性があります。複数回エクスポートしたデータは一致しない場合があります。
    -   複数の`DATAOUT`ファイル（例：`DATAOUT1.BIN`、`DATAOUT2.BIN`）が生成された場合、`copy /b DATAOUT1.BIN+DATAOUT2.BIN DATAOUT.BIN`（Windows）または`cat DATAOUT1.BIN DATAOUT2.BIN > DATAOUT.BIN`（Linux/macOS）を使用してそれらを結合できます。
    -   `test_menu_dump.py`を使用して`DATAOUT.BIN`からファイルを抽出できます。

## OSアップデート (OS UPDATE)

以下は、生成されたE-A800用のNORおよびNANDファイルを使用してOSアップデートを成功させる手順の例です。

1.  **TFカードのフォーマット**: 辞書のTest MenuでTFカード（2GB推奨）をフォーマットします。
2.  **NORファイルのトリミング**:
    -   パスワードが削除されたNORファイル（例：`CY123OSB.BIN`）を使用します。
    -   16進エディタ（`hexdump`など）を使用してファイルの末尾の有効なデータ境界を見つけ、`truncate`などのツールを使用して末尾の余分な`FF`パディングバイトを切り詰めます。
        ```
        hexdump -C NOR.BIN | tail -n 10 でファイルの末尾を検索します。次のような結果が得られます。

        016ecdb0  55 55 55 55 55 55 55 55  55 50 ff ff ff ff ff ff  |UUUUUUUUUP......|
        016ecdc0  ff ff ff ff ff ff ff ff  ff ff ff ff ff ff ff ff  |................|
        オフセット 016ecdc0 の10進数は 24038848 です。truncate -s 24038848 NOR.BIN を使用してファイルをトリミングします。
        ```
    
    -   トリミングしたファイルを`CY123OSB.BIN`にリネームし、TFカードに配置します。アップデータはアルファベット順で最新のファイルを選択します（例：`CY123OSE.BIN`は`CY123OSB.BIN`より優先されます）。
    -   `nor_parse.py`を使用してNORイメージから`UPDADN3.BIN`（または`UPDADN2.BIN`）を展開し、それもTFカードに配置します。
3.  **NANDイメージの生成**:
    -   `nand_build.py`を使用してNAND書き込みイメージをビルドします：
        ```sh
        python nand_build.py --layout dp5 --model C123 --ext-model CY123 files_folder CY123D0B.BIN
        ```
    -   `files_folder`内のファイルは、`DATAOUT`によるエラーを避けるため、`copy_nand`アドオンを使用して辞書からコピーすることを推奨します。
    -   生成されたNANDイメージ（例：`CY123D0B.BIN`）もTFカードに配置します。
4.  **アップデート開始**:
    -   `UPDADN*.BIN`、NORイメージ、NANDイメージを含むTFカードを辞書に挿入します。
    -   Test Menuに入り、アップデートを実行します。NORのみ、NANDのみ、または両方をアップデートできます。
