/**
 格式
 config = {
 "prompt": "将英语翻译成精炼的中文，不要解释",
 "url": "https://gemini.leon406.top/v1beta/openai/chat/completions", // 可不加  v1/chat/completions,  支持轮询，可用, ，;；任意分割
 "ak": "",  // 标准， 不需要 'Bearer ' 前缀,支持轮询，可用, ，;；任意分割
 "ak2": "",  // 非标ak2, 需要完整头信息
 "model": "gemini-2.5-flash-lite",
 "temperature": 1.1,
 "requestCount": 0,
 "headers": {},
 }

 **/
async function openapi(enEle, chnEle, config) {
    const REG_SEPARATOR = /[, ，;；]/
    const chatHistory = [];
    chatHistory.push({
        "role": "system",
        "content": config.prompt
    });
    chatHistory.push({
        "role": "user",
        "content": enEle.textContent
    });
    if (!chnEle) {
        let chn = document.createElement("chn")
        enEle.append(chn)
        chnEle = document.createElement("ai");
        chn.append(chnEle)
    }
    // 轮询
    let aks = config.ak.split(REG_SEPARATOR);
    let requestCount = config.requestCount
    let baseUrls = config.url.split(REG_SEPARATOR);
    let ak = aks[requestCount % aks.length];
    let baseUrl = baseUrls[requestCount % baseUrls.length];
    if (!baseUrl.includes("/chat/completions")) {
        baseUrl = baseUrl + "/v1/chat/completions"
    }
    config.requestCount++;
    try {
        const start = Date.now();
        const additionHeaders = config.headers ? config.headers : {}
        let reqObj = {
            "messages": chatHistory,
            "stream": true,
            "temperature": config.temperature,
            // "max_tokens": 150,
            "model": config.model
        }

        const response = await fetch(baseUrl, {
            method: 'POST',
            headers: {
                ...additionHeaders,
                'Content-Type': 'application/json',
                'Authorization': config.ak2 ? config.ak2 : 'Bearer ' + ak,
            },
            body: JSON.stringify(reqObj)
        });
        if (!response.ok) {
            console.error("error")
            response.text()
                .then(result => {
                    chnEle.textContent = result
                })
                .catch(error => {
                    chnEle.textContent = error
                })
        } else {
            const reader = response.body.getReader();
            const decoder = new TextDecoder('utf-8');
            let partialContent = "";
            let firstTokenTime = 0;
            let usage = null;

            while (true) {
                const {done, value} = await reader.read();
                if (!firstTokenTime) {
                    firstTokenTime = Date.now() - start
                    console.log(`===> 首帧时间: ${firstTokenTime} ms`)
                    chnEle.textContent = ""
                }
                if (done) break;
                const chunk = decoder.decode(value, {
                    stream: true
                });
                partialContent += chunk;

                // 异常直接返回json格式
                if (partialContent.startsWith("{")) {
                    if (partialContent.includes('"choices"')) {
                        chnEle.textContent = JSON.parse(partialContent)["choices"][0]["message"]["content"]
                        return;
                    }
                    chnEle.textContent = partialContent
                    return;
                }
                const lines = partialContent.split('\n');

                for (let line of lines) {
                    if (!line) continue;
                    if (line.trim().startsWith("data:")) {
                        const jsonStr = line.replace("data:", "").trim();
                        console.log("____", jsonStr)
                        if (jsonStr === "") continue;
                        if (jsonStr === "[DONE]") {
                            if (!chnEle.textContent) {
                                chnEle.textContent = "Error: No Data!"
                            }
                            break;
                        }

                        try {
                            const jsonData = JSON.parse(jsonStr);
                            // error message
                            if (jsonData['message'] || jsonData['error']) {
                                chnEle.textContent = jsonStr
                                return
                            }
                            if (!jsonData.choices.length) continue
                            const content = jsonData.choices[0].delta.content;

                            if (jsonData.usage) {
                                usage = jsonData.usage
                            }
                            if (content) {
                                chnEle.textContent += content;
                            }
                        } catch (error) {
                            console.error("解析JSON时出错: ", error);
                        }
                    }
                }
                partialContent = lines[lines.length - 1];
            }
            const totalTime = Date.now() - start
            const streamTime = totalTime - firstTokenTime
            chnEle.title = `👉: ${firstTokenTime} ms 🛑: ${totalTime} ms ⏰: ${streamTime} ms`
        }
    } catch (error) {
        console.error('获取响应时出错:', error);
        chnEle.textContent = "连接服务器时出现错误！！！"
    }
}
