# 纯 Python RIPEMD-128

def rol32(x, n):
    return ((x << n) | (x >> (32 - n))) & 0xFFFFFFFF

def F(x, y, z):
    return (x ^ y ^ z) & 0xFFFFFFFF

def G(x, y, z):
    return ((x & y) | ((~x & 0xFFFFFFFF) & z)) & 0xFFFFFFFF

def H(x, y, z):
    return ((x | (~y & 0xFFFFFFFF)) ^ z) & 0xFFFFFFFF

def I(x, y, z):
    return ((x & z) | (y & (~z & 0xFFFFFFFF))) & 0xFFFFFFFF

def ripemd128(data):

    # 接受 str 或 bytes
    if isinstance(data, str):
        data = data.encode('utf-8')
    elif not isinstance(data, (bytes, bytearray)):
        raise TypeError("data must be bytes or str")

    # 填充
    ml = (len(data) * 8) & 0xFFFFFFFFFFFFFFFF
    data = bytearray(data)
    data.append(0x80)
    while (len(data) % 64) != 56:
        data.append(0x00)
    data += ml.to_bytes(8, 'little')

    # 初始值
    h0 = 0x67452301
    h1 = 0xEFCDAB89
    h2 = 0x98BADCFE
    h3 = 0x10325476

    # 分块处理
    for offset in range(0, len(data), 64):
        block = data[offset:offset+64]
        x = [int.from_bytes(block[i*4:(i+1)*4], 'little') for i in range(16)]

        aa, bb, cc, dd = h0, h1, h2, h3
        aaa, bbb, ccc, ddd = h0, h1, h2, h3

        # 左线（主轮）
        aa = rol32((aa + F(bb, cc, dd) + x[0]) & 0xFFFFFFFF, 11)
        dd = rol32((dd + F(aa, bb, cc) + x[1]) & 0xFFFFFFFF, 14)
        cc = rol32((cc + F(dd, aa, bb) + x[2]) & 0xFFFFFFFF, 15)
        bb = rol32((bb + F(cc, dd, aa) + x[3]) & 0xFFFFFFFF, 12)
        aa = rol32((aa + F(bb, cc, dd) + x[4]) & 0xFFFFFFFF, 5)
        dd = rol32((dd + F(aa, bb, cc) + x[5]) & 0xFFFFFFFF, 8)
        cc = rol32((cc + F(dd, aa, bb) + x[6]) & 0xFFFFFFFF, 7)
        bb = rol32((bb + F(cc, dd, aa) + x[7]) & 0xFFFFFFFF, 9)
        aa = rol32((aa + F(bb, cc, dd) + x[8]) & 0xFFFFFFFF, 11)
        dd = rol32((dd + F(aa, bb, cc) + x[9]) & 0xFFFFFFFF, 13)
        cc = rol32((cc + F(dd, aa, bb) + x[10]) & 0xFFFFFFFF, 14)
        bb = rol32((bb + F(cc, dd, aa) + x[11]) & 0xFFFFFFFF, 15)
        aa = rol32((aa + F(bb, cc, dd) + x[12]) & 0xFFFFFFFF, 6)
        dd = rol32((dd + F(aa, bb, cc) + x[13]) & 0xFFFFFFFF, 7)
        cc = rol32((cc + F(dd, aa, bb) + x[14]) & 0xFFFFFFFF, 9)
        bb = rol32((bb + F(cc, dd, aa) + x[15]) & 0xFFFFFFFF, 8)

        aa = rol32((aa + G(bb, cc, dd) + x[7] + 0x5A827999) & 0xFFFFFFFF, 7)
        dd = rol32((dd + G(aa, bb, cc) + x[4] + 0x5A827999) & 0xFFFFFFFF, 6)
        cc = rol32((cc + G(dd, aa, bb) + x[13] + 0x5A827999) & 0xFFFFFFFF, 8)
        bb = rol32((bb + G(cc, dd, aa) + x[1] + 0x5A827999) & 0xFFFFFFFF, 13)
        aa = rol32((aa + G(bb, cc, dd) + x[10] + 0x5A827999) & 0xFFFFFFFF, 11)
        dd = rol32((dd + G(aa, bb, cc) + x[6] + 0x5A827999) & 0xFFFFFFFF, 9)
        cc = rol32((cc + G(dd, aa, bb) + x[15] + 0x5A827999) & 0xFFFFFFFF, 7)
        bb = rol32((bb + G(cc, dd, aa) + x[3] + 0x5A827999) & 0xFFFFFFFF, 15)
        aa = rol32((aa + G(bb, cc, dd) + x[12] + 0x5A827999) & 0xFFFFFFFF, 7)
        dd = rol32((dd + G(aa, bb, cc) + x[0] + 0x5A827999) & 0xFFFFFFFF, 12)
        cc = rol32((cc + G(dd, aa, bb) + x[9] + 0x5A827999) & 0xFFFFFFFF, 15)
        bb = rol32((bb + G(cc, dd, aa) + x[5] + 0x5A827999) & 0xFFFFFFFF, 9)
        aa = rol32((aa + G(bb, cc, dd) + x[2] + 0x5A827999) & 0xFFFFFFFF, 11)
        dd = rol32((dd + G(aa, bb, cc) + x[14] + 0x5A827999) & 0xFFFFFFFF, 7)
        cc = rol32((cc + G(dd, aa, bb) + x[11] + 0x5A827999) & 0xFFFFFFFF, 13)
        bb = rol32((bb + G(cc, dd, aa) + x[8] + 0x5A827999) & 0xFFFFFFFF, 12)

        aa = rol32((aa + H(bb, cc, dd) + x[3] + 0x6ED9EBA1) & 0xFFFFFFFF, 11)
        dd = rol32((dd + H(aa, bb, cc) + x[10] + 0x6ED9EBA1) & 0xFFFFFFFF, 13)
        cc = rol32((cc + H(dd, aa, bb) + x[14] + 0x6ED9EBA1) & 0xFFFFFFFF, 6)
        bb = rol32((bb + H(cc, dd, aa) + x[4] + 0x6ED9EBA1) & 0xFFFFFFFF, 7)
        aa = rol32((aa + H(bb, cc, dd) + x[9] + 0x6ED9EBA1) & 0xFFFFFFFF, 14)
        dd = rol32((dd + H(aa, bb, cc) + x[15] + 0x6ED9EBA1) & 0xFFFFFFFF, 9)
        cc = rol32((cc + H(dd, aa, bb) + x[8] + 0x6ED9EBA1) & 0xFFFFFFFF, 13)
        bb = rol32((bb + H(cc, dd, aa) + x[1] + 0x6ED9EBA1) & 0xFFFFFFFF, 15)
        aa = rol32((aa + H(bb, cc, dd) + x[2] + 0x6ED9EBA1) & 0xFFFFFFFF, 14)
        dd = rol32((dd + H(aa, bb, cc) + x[7] + 0x6ED9EBA1) & 0xFFFFFFFF, 8)
        cc = rol32((cc + H(dd, aa, bb) + x[0] + 0x6ED9EBA1) & 0xFFFFFFFF, 13)
        bb = rol32((bb + H(cc, dd, aa) + x[6] + 0x6ED9EBA1) & 0xFFFFFFFF, 6)
        aa = rol32((aa + H(bb, cc, dd) + x[13] + 0x6ED9EBA1) & 0xFFFFFFFF, 5)
        dd = rol32((dd + H(aa, bb, cc) + x[11] + 0x6ED9EBA1) & 0xFFFFFFFF, 12)
        cc = rol32((cc + H(dd, aa, bb) + x[5] + 0x6ED9EBA1) & 0xFFFFFFFF, 7)
        bb = rol32((bb + H(cc, dd, aa) + x[12] + 0x6ED9EBA1) & 0xFFFFFFFF, 5)

        aa = rol32((aa + I(bb, cc, dd) + x[1] + 0x8F1BBCDC) & 0xFFFFFFFF, 11)
        dd = rol32((dd + I(aa, bb, cc) + x[9] + 0x8F1BBCDC) & 0xFFFFFFFF, 12)
        cc = rol32((cc + I(dd, aa, bb) + x[11] + 0x8F1BBCDC) & 0xFFFFFFFF, 14)
        bb = rol32((bb + I(cc, dd, aa) + x[10] + 0x8F1BBCDC) & 0xFFFFFFFF, 15)
        aa = rol32((aa + I(bb, cc, dd) + x[0] + 0x8F1BBCDC) & 0xFFFFFFFF, 14)
        dd = rol32((dd + I(aa, bb, cc) + x[8] + 0x8F1BBCDC) & 0xFFFFFFFF, 15)
        cc = rol32((cc + I(dd, aa, bb) + x[12] + 0x8F1BBCDC) & 0xFFFFFFFF, 9)
        bb = rol32((bb + I(cc, dd, aa) + x[4] + 0x8F1BBCDC) & 0xFFFFFFFF, 8)
        aa = rol32((aa + I(bb, cc, dd) + x[13] + 0x8F1BBCDC) & 0xFFFFFFFF, 9)
        dd = rol32((dd + I(aa, bb, cc) + x[3] + 0x8F1BBCDC) & 0xFFFFFFFF, 14)
        cc = rol32((cc + I(dd, aa, bb) + x[7] + 0x8F1BBCDC) & 0xFFFFFFFF, 5)
        bb = rol32((bb + I(cc, dd, aa) + x[15] + 0x8F1BBCDC) & 0xFFFFFFFF, 6)
        aa = rol32((aa + I(bb, cc, dd) + x[14] + 0x8F1BBCDC) & 0xFFFFFFFF, 8)
        dd = rol32((dd + I(aa, bb, cc) + x[5] + 0x8F1BBCDC) & 0xFFFFFFFF, 6)
        cc = rol32((cc + I(dd, aa, bb) + x[6] + 0x8F1BBCDC) & 0xFFFFFFFF, 5)
        bb = rol32((bb + I(cc, dd, aa) + x[2] + 0x8F1BBCDC) & 0xFFFFFFFF, 12)

        # 右线（并行）
        aaa = rol32((aaa + I(bbb, ccc, ddd) + x[5] + 0x50A28BE6) & 0xFFFFFFFF, 8)
        ddd = rol32((ddd + I(aaa, bbb, ccc) + x[14] + 0x50A28BE6) & 0xFFFFFFFF, 9)
        ccc = rol32((ccc + I(ddd, aaa, bbb) + x[7] + 0x50A28BE6) & 0xFFFFFFFF, 9)
        bbb = rol32((bbb + I(ccc, ddd, aaa) + x[0] + 0x50A28BE6) & 0xFFFFFFFF, 11)
        aaa = rol32((aaa + I(bbb, ccc, ddd) + x[9] + 0x50A28BE6) & 0xFFFFFFFF, 13)
        ddd = rol32((ddd + I(aaa, bbb, ccc) + x[2] + 0x50A28BE6) & 0xFFFFFFFF, 15)
        ccc = rol32((ccc + I(ddd, aaa, bbb) + x[11] + 0x50A28BE6) & 0xFFFFFFFF, 15)
        bbb = rol32((bbb + I(ccc, ddd, aaa) + x[4] + 0x50A28BE6) & 0xFFFFFFFF, 5)
        aaa = rol32((aaa + I(bbb, ccc, ddd) + x[13] + 0x50A28BE6) & 0xFFFFFFFF, 7)
        ddd = rol32((ddd + I(aaa, bbb, ccc) + x[6] + 0x50A28BE6) & 0xFFFFFFFF, 7)
        ccc = rol32((ccc + I(ddd, aaa, bbb) + x[15] + 0x50A28BE6) & 0xFFFFFFFF, 8)
        bbb = rol32((bbb + I(ccc, ddd, aaa) + x[8] + 0x50A28BE6) & 0xFFFFFFFF, 11)
        aaa = rol32((aaa + I(bbb, ccc, ddd) + x[1] + 0x50A28BE6) & 0xFFFFFFFF, 14)
        ddd = rol32((ddd + I(aaa, bbb, ccc) + x[10] + 0x50A28BE6) & 0xFFFFFFFF, 14)
        ccc = rol32((ccc + I(ddd, aaa, bbb) + x[3] + 0x50A28BE6) & 0xFFFFFFFF, 12)
        bbb = rol32((bbb + I(ccc, ddd, aaa) + x[12] + 0x50A28BE6) & 0xFFFFFFFF, 6)

        aaa = rol32((aaa + H(bbb, ccc, ddd) + x[6] + 0x5C4DD124) & 0xFFFFFFFF, 9)
        ddd = rol32((ddd + H(aaa, bbb, ccc) + x[11] + 0x5C4DD124) & 0xFFFFFFFF, 13)
        ccc = rol32((ccc + H(ddd, aaa, bbb) + x[3] + 0x5C4DD124) & 0xFFFFFFFF, 15)
        bbb = rol32((bbb + H(ccc, ddd, aaa) + x[7] + 0x5C4DD124) & 0xFFFFFFFF, 7)
        aaa = rol32((aaa + H(bbb, ccc, ddd) + x[0] + 0x5C4DD124) & 0xFFFFFFFF, 12)
        ddd = rol32((ddd + H(aaa, bbb, ccc) + x[13] + 0x5C4DD124) & 0xFFFFFFFF, 8)
        ccc = rol32((ccc + H(ddd, aaa, bbb) + x[5] + 0x5C4DD124) & 0xFFFFFFFF, 9)
        bbb = rol32((bbb + H(ccc, ddd, aaa) + x[10] + 0x5C4DD124) & 0xFFFFFFFF, 11)
        aaa = rol32((aaa + H(bbb, ccc, ddd) + x[14] + 0x5C4DD124) & 0xFFFFFFFF, 7)
        ddd = rol32((ddd + H(aaa, bbb, ccc) + x[15] + 0x5C4DD124) & 0xFFFFFFFF, 7)
        ccc = rol32((ccc + H(ddd, aaa, bbb) + x[8] + 0x5C4DD124) & 0xFFFFFFFF, 12)
        bbb = rol32((bbb + H(ccc, ddd, aaa) + x[12] + 0x5C4DD124) & 0xFFFFFFFF, 7)
        aaa = rol32((aaa + H(bbb, ccc, ddd) + x[4] + 0x5C4DD124) & 0xFFFFFFFF, 6)
        ddd = rol32((ddd + H(aaa, bbb, ccc) + x[9] + 0x5C4DD124) & 0xFFFFFFFF, 15)
        ccc = rol32((ccc + H(ddd, aaa, bbb) + x[1] + 0x5C4DD124) & 0xFFFFFFFF, 13)
        bbb = rol32((bbb + H(ccc, ddd, aaa) + x[2] + 0x5C4DD124) & 0xFFFFFFFF, 11)

        aaa = rol32((aaa + G(bbb, ccc, ddd) + x[15] + 0x6D703EF3) & 0xFFFFFFFF, 9)
        ddd = rol32((ddd + G(aaa, bbb, ccc) + x[5] + 0x6D703EF3) & 0xFFFFFFFF, 7)
        ccc = rol32((ccc + G(ddd, aaa, bbb) + x[1] + 0x6D703EF3) & 0xFFFFFFFF, 15)
        bbb = rol32((bbb + G(ccc, ddd, aaa) + x[3] + 0x6D703EF3) & 0xFFFFFFFF, 11)
        aaa = rol32((aaa + G(bbb, ccc, ddd) + x[7] + 0x6D703EF3) & 0xFFFFFFFF, 8)
        ddd = rol32((ddd + G(aaa, bbb, ccc) + x[14] + 0x6D703EF3) & 0xFFFFFFFF, 6)
        ccc = rol32((ccc + G(ddd, aaa, bbb) + x[6] + 0x6D703EF3) & 0xFFFFFFFF, 6)
        bbb = rol32((bbb + G(ccc, ddd, aaa) + x[9] + 0x6D703EF3) & 0xFFFFFFFF, 14)
        aaa = rol32((aaa + G(bbb, ccc, ddd) + x[11] + 0x6D703EF3) & 0xFFFFFFFF, 12)
        ddd = rol32((ddd + G(aaa, bbb, ccc) + x[8] + 0x6D703EF3) & 0xFFFFFFFF, 13)
        ccc = rol32((ccc + G(ddd, aaa, bbb) + x[12] + 0x6D703EF3) & 0xFFFFFFFF, 5)
        bbb = rol32((bbb + G(ccc, ddd, aaa) + x[2] + 0x6D703EF3) & 0xFFFFFFFF, 14)
        aaa = rol32((aaa + G(bbb, ccc, ddd) + x[10] + 0x6D703EF3) & 0xFFFFFFFF, 13)
        ddd = rol32((ddd + G(aaa, bbb, ccc) + x[0] + 0x6D703EF3) & 0xFFFFFFFF, 13)
        ccc = rol32((ccc + G(ddd, aaa, bbb) + x[4] + 0x6D703EF3) & 0xFFFFFFFF, 7)
        bbb = rol32((bbb + G(ccc, ddd, aaa) + x[13] + 0x6D703EF3) & 0xFFFFFFFF, 5)

        aaa = rol32((aaa + F(bbb, ccc, ddd) + x[8]) & 0xFFFFFFFF, 15)
        ddd = rol32((ddd + F(aaa, bbb, ccc) + x[6]) & 0xFFFFFFFF, 5)
        ccc = rol32((ccc + F(ddd, aaa, bbb) + x[4]) & 0xFFFFFFFF, 8)
        bbb = rol32((bbb + F(ccc, ddd, aaa) + x[1]) & 0xFFFFFFFF, 11)
        aaa = rol32((aaa + F(bbb, ccc, ddd) + x[3]) & 0xFFFFFFFF, 14)
        ddd = rol32((ddd + F(aaa, bbb, ccc) + x[11]) & 0xFFFFFFFF, 14)
        ccc = rol32((ccc + F(ddd, aaa, bbb) + x[15]) & 0xFFFFFFFF, 6)
        bbb = rol32((bbb + F(ccc, ddd, aaa) + x[0]) & 0xFFFFFFFF, 14)
        aaa = rol32((aaa + F(bbb, ccc, ddd) + x[5]) & 0xFFFFFFFF, 6)
        ddd = rol32((ddd + F(aaa, bbb, ccc) + x[12]) & 0xFFFFFFFF, 9)
        ccc = rol32((ccc + F(ddd, aaa, bbb) + x[2]) & 0xFFFFFFFF, 12)
        bbb = rol32((bbb + F(ccc, ddd, aaa) + x[13]) & 0xFFFFFFFF, 9)
        aaa = rol32((aaa + F(bbb, ccc, ddd) + x[9]) & 0xFFFFFFFF, 12)
        ddd = rol32((ddd + F(aaa, bbb, ccc) + x[7]) & 0xFFFFFFFF, 5)
        ccc = rol32((ccc + F(ddd, aaa, bbb) + x[10]) & 0xFFFFFFFF, 15)
        bbb = rol32((bbb + F(ccc, ddd, aaa) + x[14]) & 0xFFFFFFFF, 8)

        t = (h1 + cc + ddd) & 0xFFFFFFFF
        h1 = (h2 + dd + aaa) & 0xFFFFFFFF
        h2 = (h3 + aa + bbb) & 0xFFFFFFFF
        h3 = (h0 + bb + ccc) & 0xFFFFFFFF
        h0 = t

    digest = (h0.to_bytes(4, 'little') + h1.to_bytes(4, 'little') + h2.to_bytes(4, 'little') + h3.to_bytes(4, 'little'))
    return digest
    return ''.join('{:02x}'.format(b) for b in digest)

"""
#print(ripemd128("abc"))


#def swap_nibble(byte):
    #等价于宏 SWAPNIBBLE
    #return ((byte >> 4) | (byte << 4)) & 0xFF


#def encrypt(buf: bytearray, key: bytes):
    #buf: bytearray，可原地修改
    #key: bytes
    buflen = len(buf)
    keylen = len(key)

    prev = 0x36
    for i in range(buflen):
        b = buf[i] ^ i ^ key[i % keylen] ^ prev
        buf[i] = ((b >> 4) | (b << 4)) & 0xFF
        prev = buf[i]

a = encrypt(buf=bytearray(b"abc"), key=bytes.fromhex(ripemd128("abc")))

data = bytearray(b"hello world")
key = bytes.fromhex(ripemd128("abc"))

encrypt(data, key)
print(data)
"""