(function() {
    'use strict';
    
    // 双语词典中文显示/隐藏功能
    function translationToggle(){
        // 只针对我们特定词典的内容（使用ID选择器）
        var ourDictionary = document.getElementById('ID270233870child');
        
        if (!ourDictionary) return;
        if (!ourDictionary.querySelector('.trans')) return;
        
        var elements = ourDictionary.querySelectorAll('.def, .exa');
        for (var i = 0; i < elements.length; i++) {
            (function(element) {
                element.style.cursor = 'pointer';
                element.addEventListener('click', function(e) {
                    if (e.target.closest('.def-info')) return;
                    e.stopPropagation();
                    
                    var translations;
                    if (this.classList.contains('def')) {
                        var defInfo = this.querySelector('.def-info') || this.closest('.def-block').querySelector('.def-info');
                        translations = defInfo ? defInfo.querySelectorAll('.trans') : [];
                    } else {
                        translations = this.querySelectorAll('.trans');
                    }
                    
                    if (translations.length === 0) return;
                    
                    var isVisible = translations[0].classList.contains('trans-visible');
                    for (var j = 0; j < translations.length; j++) {
                        if (isVisible) {
                            translations[j].classList.remove('trans-visible');
                        } else {
                            translations[j].classList.add('trans-visible');
                        }
                    }
                });
            })(elements[i]);
        }
    }
    
    // 延迟执行，确保DOM完全加载
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', translationToggle);
    } else {
        setTimeout(translationToggle, 100);
    }
})();