import json
import requests
import os

ids = {}

for char in 'abcdefghijklmnopqrstuvwxyz':
    with open(f'../jsons_ordered/response_{char}.json', 'r', encoding='utf-8') as fi:
        char_js = json.loads(fi.read())
    for entry in char_js:
        entry_id = entry['id']
        ids[entry_id] = True
print(f'{len(ids)=}')
dictLocal = {}


for filename in os.listdir(f'../jsons_mysql/'):
    name_without_extension = os.path.splitext(filename)[0].replace('.', '')
    dictLocal[name_without_extension] = True  # 使用 True 作为占位符

dictOutput = {}
for k, v in ids.items():
    entry_id = k
    if entry_id in dictLocal:
        pass
    else:
        dictOutput[entry_id] = True

with open('missing_files.json', 'w') as f:
    json.dump(dictOutput, f, indent=4)
