
# 文字数据
# https://johnsonsdictionaryonline.com/ajax/displayWord.php
# query=display-word.xq&directory=%2Fdb%2Fapps%2Fsjd%2Fdata%2F1755%2FA&folio=1755&ip=&filename=f1755-ait-1.xml

# 图数据
# 先 head , 好像可以省略
# https://johnsonsdictionaryonline.com/ajax/displayWord.php
#  再 get
# https://johnsonsdictionaryonline.com/img/words/f1755-ait-1.png

import json
import requests

for char in 'abcdefghijklmnopqrstuvwxyz':
    with open(f'../jsons_ordered/response_{char}.json', 'r', encoding='utf-8') as fi:
        char_js = json.loads(fi.read())
    for entry in char_js:
        entry_id = entry['id']
        if int(entry_id) > 70364:
            year = entry['edition']
            hwd_in_url = entry['permalink']
            sql_url = 'https://johnsonsdictionaryonline.com/ajax/search_mysql_new.php'
            data = {
                'searchterm': f'{hwd_in_url}',
                'query': 'permalink',
                'searchYear': int(year)
            }
            response = requests.post(sql_url, data=data)
            if response.status_code == 200:
                try:
                    json_data = response.json()
                    
                    # Save the JSON data to a local file
                    with open(f'../jsons_mysql/{entry_id}.json', 'w', encoding='utf-8') as json_file:
                        json.dump(json_data, json_file, ensure_ascii=False, indent=4)  # Write JSON data to the file
                    
                except json.JSONDecodeError:
                    print("Failed to decode JSON from the response.")
            else:
                print("Failed to retrieve data:", response.status_code)
        else:
            pass



# {
#     "word": "eyght_ns",
#     "andor": "or",
#     "tag": "permalink",
#     "searchNumber": 1,
#     "filenames": [
#         "A/f1755-ait-1.xml"
#     ],
#     "pageimages": [
#         "f1755-v1-0113.png"
#     ],
#     "labels": [
#         "eyght, n.s."
#     ],
#     "headwords": [
#         "eyght"
#     ],
#     "permalinks": [
#         "eyght_ns"
#     ]
# }

