import requests
import json

# Define the URL
url = 'https://johnsonsdictionaryonline.com/ajax/letter_range.php'

# Loop through each character from 'a' to 'z'
for char in range(ord('a'), ord('z') + 1):
    label_value = f"{chr(char)}%"  # Create the label value (e.g., 'a%', 'b%', ..., 'z%')
    data = {
        'label': label_value,
        'dictionary_order': 'true'
    }

    # Send the POST request
    response = requests.post(url, data=data)

    # Check if the request was successful
    if response.status_code == 200:
        # Parse the JSON response
        response_json = response.json()
        
        # Save the JSON response to a local file named after the character
        filename = f'response_{label_value[:-1]}.json'  # e.g., response_a.json
        with open('../jsons_ordered/' + filename, 'w') as json_file:
            json.dump(response_json, json_file, indent=4)  # Save with pretty printing
        
        print(f"Response JSON for '{label_value}' saved to '{filename}'")
    else:
        print(f"Failed to retrieve data for '{label_value}':", response.status_code)
